/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.core.FastVector;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;

public class BIFParser
implements GraphConstants {
    protected FastVector m_nodes;
    protected FastVector m_edges;
    protected String graphName;
    protected String inString;
    protected InputStream inStream;

    public BIFParser(String input, FastVector nodes, FastVector edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.inString = input;
    }

    public BIFParser(InputStream instream, FastVector nodes, FastVector edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.inStream = instream;
    }

    public String parse() throws Exception {
        GraphEdge e;
        int j;
        GraphNode n;
        Document dc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (this.inStream != null) {
            dc = db.parse(this.inStream);
        } else if (this.inString != null) {
            dc = db.parse(new InputSource(new StringReader(this.inString)));
        } else {
            throw new Exception("No input given");
        }
        NodeList nl = dc.getElementsByTagName("NETWORK");
        if (nl.getLength() == 0) {
            throw new BIFFormatException("NETWORK tag not found");
        }
        NodeList templist = ((Element)nl.item(0)).getElementsByTagName("NAME");
        this.graphName = templist.item(0).getFirstChild().getNodeValue();
        nl = dc.getElementsByTagName("VARIABLE");
        int i = 0;
        while (i < nl.getLength()) {
            templist = ((Element)nl.item(i)).getElementsByTagName("NAME");
            if (templist.getLength() > 1) {
                throw new BIFFormatException("More than one name tags found for variable no. " + (i + 1));
            }
            String nodename = templist.item(0).getFirstChild().getNodeValue();
            n = new GraphNode(nodename, nodename, 3);
            this.m_nodes.addElement(n);
            templist = ((Element)nl.item(i)).getElementsByTagName("PROPERTY");
            j = 0;
            while (j < templist.getLength()) {
                if (templist.item(j).getFirstChild().getNodeValue().startsWith("position")) {
                    String xy = templist.item(j).getFirstChild().getNodeValue();
                    n.x = Integer.parseInt(xy.substring(xy.indexOf(40) + 1, xy.indexOf(44)).trim());
                    n.y = Integer.parseInt(xy.substring(xy.indexOf(44) + 1, xy.indexOf(41)).trim());
                    break;
                }
                ++j;
            }
            templist = ((Element)nl.item(i)).getElementsByTagName("OUTCOME");
            n.outcomes = new String[templist.getLength()];
            j = 0;
            while (j < templist.getLength()) {
                n.outcomes[j] = templist.item(j).getFirstChild().getNodeValue();
                ++j;
            }
            ++i;
        }
        nl = dc.getElementsByTagName("DEFINITION");
        i = 0;
        while (i < nl.getLength()) {
            templist = ((Element)nl.item(i)).getElementsByTagName("FOR");
            String nid = templist.item(0).getFirstChild().getNodeValue();
            n = (GraphNode)this.m_nodes.elementAt(0);
            j = 1;
            while (j < this.m_nodes.size() && !n.ID.equals(nid)) {
                n = (GraphNode)this.m_nodes.elementAt(j);
                ++j;
            }
            templist = ((Element)nl.item(i)).getElementsByTagName("GIVEN");
            int parntOutcomes = 1;
            int j2 = 0;
            while (j2 < templist.getLength()) {
                nid = templist.item(j2).getFirstChild().getNodeValue();
                GraphNode n2 = (GraphNode)this.m_nodes.elementAt(0);
                int k = 1;
                while (k < this.m_nodes.size() && !n2.ID.equals(nid)) {
                    n2 = (GraphNode)this.m_nodes.elementAt(k);
                    ++k;
                }
                this.m_edges.addElement(new GraphEdge(this.m_nodes.indexOf(n2), this.m_nodes.indexOf(n), 1));
                parntOutcomes *= n2.outcomes.length;
                ++j2;
            }
            templist = ((Element)nl.item(i)).getElementsByTagName("TABLE");
            if (templist.getLength() > 1) {
                throw new BIFFormatException("More than one Probability Table for " + n.ID);
            }
            String probs = templist.item(0).getFirstChild().getNodeValue();
            StringTokenizer tk = new StringTokenizer(probs, " \n\t");
            if (parntOutcomes * n.outcomes.length > tk.countTokens()) {
                throw new BIFFormatException("Probability Table for " + n.ID + " contains more values than it should");
            }
            if (parntOutcomes * n.outcomes.length < tk.countTokens()) {
                throw new BIFFormatException("Probability Table for " + n.ID + " contains less values than it should");
            }
            n.probs = new double[parntOutcomes][n.outcomes.length];
            int r = 0;
            while (r < parntOutcomes) {
                int c = 0;
                while (c < n.outcomes.length) {
                    n.probs[r][c] = Double.parseDouble(tk.nextToken());
                    ++c;
                }
                ++r;
            }
            ++i;
        }
        int[] noOfEdgesOfNode = new int[this.m_nodes.size()];
        int[] noOfPrntsOfNode = new int[this.m_nodes.size()];
        int i2 = 0;
        while (i2 < this.m_edges.size()) {
            e = (GraphEdge)this.m_edges.elementAt(i2);
            int n2 = e.src;
            noOfEdgesOfNode[n2] = noOfEdgesOfNode[n2] + 1;
            int n3 = e.dest;
            noOfPrntsOfNode[n3] = noOfPrntsOfNode[n3] + 1;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_edges.size()) {
            int k;
            e = (GraphEdge)this.m_edges.elementAt(i2);
            GraphNode n4 = (GraphNode)this.m_nodes.elementAt(e.src);
            GraphNode n2 = (GraphNode)this.m_nodes.elementAt(e.dest);
            if (n4.edges == null) {
                n4.edges = new int[noOfEdgesOfNode[e.src]][2];
                k = 0;
                while (k < n4.edges.length) {
                    n4.edges[k][0] = -1;
                    ++k;
                }
            }
            if (n2.prnts == null) {
                n2.prnts = new int[noOfPrntsOfNode[e.dest]];
                k = 0;
                while (k < n2.prnts.length) {
                    n2.prnts[k] = -1;
                    ++k;
                }
            }
            k = 0;
            while (n4.edges[k][0] != -1) {
                ++k;
            }
            n4.edges[k][0] = e.dest;
            n4.edges[k][1] = e.type;
            k = 0;
            while (n2.prnts[k] != -1) {
                ++k;
            }
            n2.prnts[k] = e.src;
            ++i2;
        }
        return this.graphName;
    }

    public static void writeXMLBIF03(String filename, String graphName, FastVector nodes, FastVector edges) {
        try {
            GraphNode n;
            FileWriter outfile = new FileWriter(filename);
            StringBuffer text = new StringBuffer();
            text.append("<?xml version=\"1.0\"?>\n");
            text.append("<!-- DTD for the XMLBIF 0.3 format -->\n");
            text.append("<!DOCTYPE BIF [\n");
            text.append("\t<!ELEMENT BIF ( NETWORK )*>\n");
            text.append("\t      <!ATTLIST BIF VERSION CDATA #REQUIRED>\n");
            text.append("\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n");
            text.append("\t<!ELEMENT NAME (#PCDATA)>\n");
            text.append("\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n");
            text.append("\t      <!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n");
            text.append("\t<!ELEMENT OUTCOME (#PCDATA)>\n");
            text.append("\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n");
            text.append("\t<!ELEMENT FOR (#PCDATA)>\n");
            text.append("\t<!ELEMENT GIVEN (#PCDATA)>\n");
            text.append("\t<!ELEMENT TABLE (#PCDATA)>\n");
            text.append("\t<!ELEMENT PROPERTY (#PCDATA)>\n");
            text.append("]>\n");
            text.append("\n");
            text.append("\n");
            text.append("<BIF VERSION=\"0.3\">\n");
            text.append("<NETWORK>\n");
            text.append("<NAME>" + BIFParser.XMLNormalize(graphName) + "</NAME>\n");
            int nodeidx = 0;
            while (nodeidx < nodes.size()) {
                n = (GraphNode)nodes.elementAt(nodeidx);
                if (n.nodeType == 3) {
                    text.append("<VARIABLE TYPE=\"nature\">\n");
                    text.append("\t<NAME>" + BIFParser.XMLNormalize(n.ID) + "</NAME>\n");
                    if (n.outcomes != null) {
                        int outidx = 0;
                        while (outidx < n.outcomes.length) {
                            text.append("\t<OUTCOME>" + BIFParser.XMLNormalize(n.outcomes[outidx]) + "</OUTCOME>\n");
                            ++outidx;
                        }
                    } else {
                        text.append("\t<OUTCOME>true</OUTCOME>\n");
                    }
                    text.append("\t<PROPERTY>position = (" + n.x + "," + n.y + ")</PROPERTY>\n");
                    text.append("</VARIABLE>\n");
                }
                ++nodeidx;
            }
            nodeidx = 0;
            while (nodeidx < nodes.size()) {
                n = (GraphNode)nodes.elementAt(nodeidx);
                if (n.nodeType == 3) {
                    text.append("<DEFINITION>\n");
                    text.append("<FOR>" + BIFParser.XMLNormalize(n.ID) + "</FOR>\n");
                    int parntOutcomes = 1;
                    if (n.prnts != null) {
                        int pidx = 0;
                        while (pidx < n.prnts.length) {
                            GraphNode prnt = (GraphNode)nodes.elementAt(n.prnts[pidx]);
                            text.append("\t<GIVEN>" + BIFParser.XMLNormalize(prnt.ID) + "</GIVEN>\n");
                            if (prnt.outcomes != null) {
                                parntOutcomes *= prnt.outcomes.length;
                            }
                            ++pidx;
                        }
                    }
                    text.append("<TABLE>\n");
                    int i = 0;
                    while (i < parntOutcomes) {
                        if (n.outcomes != null) {
                            int outidx = 0;
                            while (outidx < n.outcomes.length) {
                                text.append(String.valueOf(n.probs[i][outidx]) + " ");
                                ++outidx;
                            }
                        } else {
                            text.append("1");
                        }
                        text.append('\n');
                        ++i;
                    }
                    text.append("</TABLE>\n");
                    text.append("</DEFINITION>\n");
                }
                ++nodeidx;
            }
            text.append("</NETWORK>\n");
            text.append("</BIF>\n");
            outfile.write(text.toString());
            outfile.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static String XMLNormalize(String sStr) {
        StringBuffer sStr2 = new StringBuffer();
        int iStr = 0;
        while (iStr < sStr.length()) {
            char c = sStr.charAt(iStr);
            switch (c) {
                case '&': {
                    sStr2.append("&amp;");
                    break;
                }
                case '\'': {
                    sStr2.append("&apos;");
                    break;
                }
                case '\"': {
                    sStr2.append("&quot;");
                    break;
                }
                case '<': {
                    sStr2.append("&lt;");
                    break;
                }
                case '>': {
                    sStr2.append("&gt;");
                    break;
                }
                default: {
                    sStr2.append(c);
                }
            }
            ++iStr;
        }
        return sStr2.toString();
    }
}

